IF EXISTS
(
    SELECT *
    FROM SYS.PROCEDURES
    WHERE NAME = 'P_CTB_CNT_DRE_CONSLD_VD_MES_EXECUTE_ALL'
)
    DROP PROCEDURE P_CTB_CNT_DRE_CONSLD_VD_MES_EXECUTE_ALL;
GO
CREATE PROCEDURE P_CTB_CNT_DRE_CONSLD_VD_MES_EXECUTE_ALL(@MES INT,@ANO INT=0)
AS
	 DECLARE @CD_EMP INT;
     DECLARE @CD_FILIAL INT;
     BEGIN
		 IF @ANO=0
		 BEGIN
			SET @ANO = YEAR(GETDATE());
		 END

         DECLARE FILIAL_CURSOR CURSOR
         FOR SELECT 
				CD_EMP,
				CD_FILIAL
             FROM PRC_FILIAL
             ORDER BY CD_FILIAL ASC;

         -- ABRINDO CURSOR PARA LEITURA
         OPEN FILIAL_CURSOR;

         -- LENDO A PRXIMA LINHA
         FETCH NEXT FROM FILIAL_CURSOR INTO @CD_EMP,@CD_FILIAL;
         WHILE @@FETCH_STATUS = 0
             BEGIN
		   print 'filial a ser executada: '+convert(varchar,@cd_filial) + ' '+ 'Data :' + convert(varchar,getdate()) 
                 EXEC P_CTB_CNT_DRE_CONSLD_VD_MES
                      @CD_EMP,
                      @CD_FILIAL,
                      @ANO,
                      @MES;
		   FETCH NEXT FROM FILIAL_CURSOR INTO @CD_EMP,@CD_FILIAL;
             END;
	   

         CLOSE FILIAL_CURSOR;
         DEALLOCATE FILIAL_CURSOR;
     END;